% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pums.R
\name{get_pums}
\alias{get_pums}
\title{Load data from the American Community Survey Public Use Microdata Series API}
\usage{
get_pums(
  variables = NULL,
  state = NULL,
  puma = NULL,
  year = 2022,
  survey = "acs5",
  variables_filter = NULL,
  rep_weights = NULL,
  recode = FALSE,
  return_vacant = FALSE,
  show_call = FALSE,
  key = NULL
)
}
\arguments{
\item{variables}{A vector of variables from the PUMS API.
Use \code{View(pums_variables)} to browse variable options.}

\item{state}{A state, or vector of states, for which you would like to
request data.  The entire US can be requested with \code{state = "all"} - though be patient with the data download!}

\item{puma}{A vector of PUMAs from a single state, for which you would like
to request data. To get data from PUMAs in more than one state, specify a
named vector of state/PUMA pairs and set \code{state = "multiple"}.}

\item{year}{The data year of the 1-year ACS sample or the endyear of the
5-year sample. Defaults to 2022. Please note that 1-year data for 2020 is not available
in tidycensus, so users requesting 1-year data should supply a different year.}

\item{survey}{The ACS survey; one of either \code{"acs1"} or \code{"acs5"}
(the default).}

\item{variables_filter}{A named list of filters you'd like to return from the
PUMS API.  For example, passing \code{list(AGE = 25:50, SEX = 1)} will return
only males aged 25 to 50 in your output dataset.  Defaults to \code{NULL},
which returns all records. If a housing-only dataset is required,
use \code{list(SPORDER = 1)} to only return householder records (taking care
in your analysis to use the household weight \code{WGTP}).}

\item{rep_weights}{Whether or not to return housing unit, person, or both
housing and person-level replicate weights for calculation of standard
errors; one of \code{"person"}, \code{"housing"}, or \code{"both"}.}

\item{recode}{If TRUE, recodes variable values using Census data dictionary
and creates a new \code{*_label} column for each variable that is recoded.
Available for 2017 - 2022 data. Defaults to FALSE.}

\item{return_vacant}{If TRUE, makes a separate request to the Census API to
retrieve microdata for vacant housing units, which are handled differently
in the API as they do not have person-level characteristics.  All person-level
columns in the returned dataset will be populated with NA for vacant housing units.
Defaults to FALSE.}

\item{show_call}{If TRUE, display call made to Census API. This can be very
useful in debugging and determining if error messages returned are due to
tidycensus or the Census API. Copy to the API call into a browser and see
what is returned by the API directly. Defaults to FALSE.}

\item{key}{Your Census API key. Obtain one at
\url{https://api.census.gov/data/key_signup.html}}
}
\value{
A tibble of microdata from the ACS PUMS API.
}
\description{
Load data from the American Community Survey Public Use Microdata Series API
}
\examples{
\dontrun{
get_pums(variables = "AGEP", state = "VT")
get_pums(variables = "AGEP", state = "multiple", puma = c("UT" = 35008, "NV" = 00403))
get_pums(variables = c("AGEP", "ANC1P"), state = "VT", recode = TRUE)
get_pums(variables = "AGEP", state = "VT", survey = "acs1", rep_weights = "person")
}

}
