% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topn_dt.R
\name{top_n_dt}
\alias{top_n_dt}
\alias{top_frac_dt}
\title{Select top (or bottom) n rows (by value)}
\usage{
top_n_dt(data, n, wt = NULL)

top_frac_dt(data, n, wt = NULL)
}
\arguments{
\item{data}{data.frame}

\item{n}{If \code{n} is positive, selects the top rows. If negative, selects the bottom rows.}

\item{wt}{(Optional). The variable to use for ordering.
If not specified, defaults to the last variable in the data.frame.}
}
\value{
data.table
}
\description{
Analogous function for \code{top_n} and \code{top_frac} in \pkg{dplyr}, but with a different API.
}
\examples{
iris \%>\% top_n_dt(10,Sepal.Length)
iris \%>\% top_n_dt(-10,Sepal.Length)
iris \%>\% top_frac_dt(.1,Sepal.Length)
iris \%>\% top_frac_dt(-.1,Sepal.Length)

}
\seealso{
\code{\link[dplyr]{top_n}}
}
