% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_census.R
\name{geo_census}
\alias{geo_census}
\title{Geocode street addresses}
\usage{
geo_census(address, lat = lat, long = long, verbose = FALSE,
  benchmark = 4,
  API_URL = "https://geocoding.geo.census.gov/geocoder/locations/onelineaddress?")
}
\arguments{
\item{address}{single line address. Street must be included.}

\item{lat}{name of latitude field}

\item{long}{name of longitude field}

\item{verbose}{logical. If TRUE outputs logs.}

\item{benchmark}{parameter for the US Census Geocoder}

\item{API_URL}{URL of Census API}
}
\value{
latitude and longitude coordinates in tibble format
}
\description{
Obtain latitude and longitude coordinates from an address using the US Census geocoder.
Only works for addresses within the US. Addresses must also be at the street
level (ie. 60 Main St. Pawnee, IN not Pawnee, IN).
}
\examples{
\donttest{
geo_census("1600 Pennsylvania Ave Washington, DC")
}
}
