% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node_measures}
\alias{node_measures}
\alias{node_eccentricity}
\alias{node_constraint}
\alias{node_coreness}
\alias{node_diversity}
\title{Querying node measures}
\usage{
node_eccentricity(mode = "out")

node_constraint(weights = NULL)

node_coreness(mode = "out")

node_diversity(weights = NULL)
}
\arguments{
\item{mode}{The way edges should be followed in the case of directed graphs.}

\item{weights}{The weights to use for each node during calculation}
}
\value{
A numeric vector of the same length as the number of nodes in the
graph.
}
\description{
These functions are a collection of node measures that do not really fall
into the class of \link{centrality} measures. For lack of a better place they are
collected under the \code{node_*} umbrella of functions.
}
\section{Functions}{
\itemize{
\item \code{node_eccentricity}: measure the maximum shortest path to all other nodes in the graph

\item \code{node_constraint}: measures Burts constraint of the node. See \code{\link[igraph:constraint]{igraph::constraint()}}

\item \code{node_coreness}: measures the coreness of each node. See \code{\link[igraph:coreness]{igraph::coreness()}}

\item \code{node_diversity}: measures the diversity of the node. See \code{\link[igraph:diversity]{igraph::diversity()}}
}}

\examples{
# Calculate Burt's Constraint for each node
create_notable('meredith') \%>\%
  mutate(b_constraint = node_constraint())
}
