% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inftheo.R
\name{mutual_info_matrix}
\alias{mutual_info_matrix}
\title{Mutual information Matrix}
\usage{
mutual_info_matrix(.data, ..., normalized = FALSE, na.rm = FALSE)
}
\arguments{
\item{.data}{A tibble with the columns of interest}

\item{...}{a selection of columns, selected in the same way as \link{select}}

\item{normalized}{if TRUE, scale from 0 to 1}

\item{na.rm}{remove all rows with NA values in at least one of the columns}
}
\value{
a 3 column tibble with each pairwise combination and its calculated mutual information
}
\description{
To simplify the task of comparing variables, this calculates a matrix of
mutual information values from each pairwise combination of the variables
selected. If 6 variables are selected, that would yield a table with
15 rows (choose(6,2)), and 3 columns.
}
\examples{
# make an all-character version of mtchars
mt_tib <- as_tibble(mtcars) \%>\% mutate_all(as.character)
mutual_info_matrix(mt_tib, 8:11)
}
