% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_json.R
\name{is_json}
\alias{is_json}
\alias{is_json_string}
\alias{is_json_number}
\alias{is_json_logical}
\alias{is_json_null}
\alias{is_json_array}
\alias{is_json_object}
\alias{is_json_scalar}
\title{Predicates to test for specific JSON types in \code{\link{tbl_json}} objects}
\usage{
is_json_string(.x)

is_json_number(.x)

is_json_logical(.x)

is_json_null(.x)

is_json_array(.x)

is_json_object(.x)

is_json_scalar(.x)
}
\arguments{
\item{.x}{a json string or \code{\link{tbl_json}} object}
}
\value{
a logical vector
}
\description{
These functions are often useful with \code{\link[dplyr]{filter}} to
filter complex JSON by type before applying \code{\link{gather_object}} or
\code{\link{gather_array}}.
}
\examples{

# Test a simple example
json <- '[1, "string", true, [1, 2], {"name": "value"}, null]' \%>\% gather_array
json \%>\% is_json_number
json \%>\% is_json_array
json \%>\% is_json_scalar

# Use with filter
library(dplyr)
json \%>\% filter(is_json_object(.))

# Combine with filter in advance of using gather_array
companies[1:5] \%>\% gather_object \%>\% filter(is_json_array(.))
companies[1:5] \%>\% gather_object \%>\% filter(is_json_array(.)) \%>\%
  gather_array

# Combine with filter in advance of using gather_object
companies[1:5] \%>\% gather_object \%>\% filter(is_json_object(.))
companies[1:5] \%>\% gather_object \%>\% filter(is_json_object(.)) \%>\%
  gather_object("name2")
}
\seealso{
\code{\link{json_types}} for creating a new column to identify the
         type of every JSON document
}
