% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{precise_example}
\alias{precise_example}
\alias{noisy_example}
\alias{concrete_example}
\alias{ts_example}
\title{Example Data Sets}
\value{
Tibbles with the additonal class \code{rset}
}
\description{
Example Data Sets
}
\details{
Several data sets are contained in the package
as examples. Each \emph{simulates} an \code{rset} object but the \code{splits}
columns are not included to save space.

\itemize{
\item{\code{precise_example} contains the results of the classification
analysis of a real data set using 10-fold CV. The holdout data
sets contained thousands of examples and have precise
performance estimates. Three models were fit to the original
data and several performance metrics are included.}

\item{\code{noisy_example} was also generated from a regression data
simulation. The original data set was small (50 samples) and
10-repeated of 10-fold CV were used with four models. There is
an excessive of variability in the results (probably more than
the resample-to-resample variability). The RMSE distributions
show fairly right-skewed distributions.}

\item{\code{concrete_example} contains the results of the regression case
study from the book \emph{Applied Predictive Modeling}. The original
data set contained 745 samples in the training set. 10-repeats
of 10-fold CV was also used and 13 models were fit to the data.}

\item{\code{ts_example} is from a data set where rolling-origin forecast
resampling was used. Each assessment set is the summary of 14
observations (i.e. 2 weeks). The analysis set consisted of a
base of about 5,500 samples plus the previous assessment sets.
Four regression models were applied to these data.}
}
}
\examples{
data(precise_example)
precise_example
}
\keyword{datasets}
