% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill.R
\name{dt_fill}
\alias{dt_fill}
\title{Fill in missing values with previous or next value}
\usage{
dt_fill(
  .data,
  ...,
  .direction = c("down", "up", "downup", "updown"),
  by = NULL
)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{...}{A selection of bare columns}

\item{.direction}{Direction in which to fill missing values. Currently "down" (the default), "up", "downup" (first down then up), or "updown" (first up and then down)}

\item{by}{Whether the filling should be done by group. Passed in a \code{list()}}
}
\value{
A data.table
}
\description{
Fills missing values in the selected columns using the next or previous entry. Can be done by group.
}
\examples{
test_df <- data.table::data.table(
  x = c(NA, NA, NA, 4:10),
  y = c(1:6, NA, 8, NA, 10),
  z = c(rep("a", 8), rep("b", 2)))

test_df \%>\%
  dt_fill(x, y, by = z)

test_df \%>\%
  dt_fill(x, y, by = z, .direction = "downup")

}
