% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifelse.R
\name{ifelse.}
\alias{ifelse.}
\alias{dt_ifelse}
\title{Vectorized if}
\usage{
ifelse.(conditions, true, false)

dt_ifelse(conditions, true, false)
}
\arguments{
\item{conditions}{Conditions to test on}

\item{true}{Values to return if conditions evaluate to TRUE}

\item{false}{Values to return if conditions evaluate to FALSE}
}
\description{
\code{ifelse.()} utilizes \code{data.table::fifelse()} in the background, but automatically
converts NAs to their proper type
}
\examples{
x <- c(1:4, 3:2, 1:4)
ifelse.(x > 2L, x, x - 1L)

# Can also be used inside of mutate.()
test_df <- data.table::data.table(x = x)

test_df \%>\%
  mutate.(new_col = ifelse.(x > 2L, NA, x - 1L))
}
