% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_by.R
\name{group_by.}
\alias{group_by.}
\title{Grouping}
\usage{
group_by.(.df, ...)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to group by}
}
\description{
\itemize{
\item \code{group_by()} adds a grouping structure to a tidytable. Can use tidyselect syntax.
\item \code{ungroup()} removes grouping.
}
}
\examples{
df <- data.table(
  a = 1:3,
  b = 4:6,
  c = c("a", "a", "b"),
  d = c("a", "a", "b")
)

df \%>\%
  group_by(c, d) \%>\%
  summarize(mean_a = mean(a)) \%>\%
  ungroup()

# Can also use tidyselect
df \%>\%
  group_by(where(is.character)) \%>\%
  summarize(mean_a = mean(a)) \%>\%
  ungroup()
}
\keyword{internal}
