% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{full_join.}
\alias{full_join.}
\title{Join two data.tables together}
\usage{
full_join.(x, y, by = NULL, suffix = c(".x", ".y"), ..., keep = FALSE)
}
\arguments{
\item{x}{A data.frame or data.table}

\item{y}{A data.frame or data.table}

\item{by}{A character vector of variables to join by. If NULL, the default, the join will do a natural join, using all variables with common names across the two tables.}

\item{suffix}{Append created for duplicated column names when using \code{full_join()}}

\item{...}{Other parameters passed on to methods}

\item{keep}{Should the join keys from both \code{x} and \code{y} be preserved in the output?}
}
\description{
Join two data.tables together
}
\examples{
df1 <- data.table(x = c("a", "a", "b", "c"), y = 1:4)
df2 <- data.table(x = c("a", "b"), z = 5:6)

df1 \%>\% left_join(df2)
df1 \%>\% inner_join(df2)
df1 \%>\% right_join(df2)
df1 \%>\% full_join(df2)
df1 \%>\% anti_join(df2)
}
\keyword{internal}
