% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull-Spat.R
\name{pull.Spat}
\alias{pull.Spat}
\alias{pull.SpatRaster}
\alias{pull.SpatVector}
\title{Extract a single layer/attribute}
\usage{
\method{pull}{SpatRaster}(.data, var = -1, name = NULL, ...)

\method{pull}{SpatVector}(.data, var = -1, name = NULL, ...)
}
\arguments{
\item{.data}{A SpatRaster created with \code{\link[terra:rast]{terra::rast()}} or a SpatVector
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{var}{A variable specified as:
\itemize{
\item a literal layer/attribute name
\item a positive integer, giving the position counting from the left
\item a negative integer, giving the position counting from the right.
}

The default returns the last layer/attribute (on the assumption that's the
column you've created most recently).}

\item{name}{An optional parameter that specifies the column to be used as
names for a named vector. Specified in a similar manner as \code{var}.}

\item{...}{Arguments passed on to \code{\link[=as_tibble]{as_tibble()}}}
}
\value{
A vector the same number of cells/geometries as \code{.data}.

On SpatRasters, note that the default (\code{na.rm = FALSE}) would remove
empty cells, so you may need to pass (\code{na.rm = FALSE}) to \code{...}. See
\code{\link[terra:as.data.frame]{terra::as.data.frame()}}.
}
\description{
\code{pull()} is similar to $ on a data frame. It's mostly useful because it
looks a little nicer in pipes and it can optionally name the output.

\strong{It is possible to extract the geographic coordinates of a SpatRaster}.
You need to use \code{pull(.data, x, xy = TRUE)}. \code{x} and \code{y} are reserved
names on terra, since they refer to the geographic coordinates of the layer.

See \strong{Examples} and section \verb{About layer names} on \code{\link[=as_tibble]{as_tibble()}}.
}
\section{terra equivalent}{


\code{\link[terra:values]{terra::values()}}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[dplyr:pull]{dplyr::pull()}} function. This is done
by coercing the Spat* object to a tibble first (see \link{as_tibble.Spat}) and
then using \code{\link[dplyr:pull]{dplyr::pull()}} method over the tibble.
\subsection{SpatRaster}{

When passing option \code{na.rm = TRUE} to \code{...}, only cells with a value
distinct to \code{NA} are extracted. See \code{\link[terra:as.data.frame]{terra::as.data.frame()}}.

If \code{xy = TRUE} option is passed to \code{...}, two columns names \code{x} and \code{y}
(corresponding to the geographic coordinates of each cell) are available
in position \code{1} and \code{2}. Hence, \code{pull(.data, 1)} and
\code{pull(.data, 1, xy = TRUE)} return different result.
}

\subsection{SpatVector}{

When passing \code{geom = "WKT"/geom = "HEX"} to \code{...},  the geometry of the
SpatVector can be pulled passing \code{var = geometry}. Similarly to SpatRaster
method, when using \code{geom = "XY"} the \verb{x,y} coordinates can be pulled with
\code{var = x/var = y}. See  \code{\link[terra:as.data.frame]{terra::as.data.frame()}} options.
}
}

\examples{

library(terra)
f <- system.file("extdata/cyl_tile.tif", package = "tidyterra")
r <- rast(f)

# Extract second layer
r \%>\%
  pull(2) \%>\%
  head()

# With xy the first two cols are `x` (longitude) and `y` (latitude)

r \%>\%
  pull(2, xy = TRUE) \%>\%
  head()

# With renaming

r \%>\%
  mutate(cat = cut(cyl_tile_3, c(0, 100, 300))) \%>\%
  pull(cyl_tile_3, name = cat) \%>\%
  head()

}
\seealso{
\code{\link[dplyr:pull]{dplyr::pull()}}

Other dplyr verbs that operate on columns:
\code{\link{glimpse.Spat}},
\code{\link{mutate.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}},
\code{\link{select.Spat}}

Other dplyr methods:
\code{\link{arrange.SpatVector}()},
\code{\link{bind_cols.SpatVector}},
\code{\link{bind_rows.SpatVector}},
\code{\link{count.SpatVector}()},
\code{\link{distinct.SpatVector}()},
\code{\link{filter-joins.SpatVector}},
\code{\link{filter.Spat}},
\code{\link{glimpse.Spat}},
\code{\link{group-by.SpatVector}},
\code{\link{mutate-joins.SpatVector}},
\code{\link{mutate.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}},
\code{\link{rowwise.SpatVector}()},
\code{\link{select.Spat}},
\code{\link{slice.Spat}},
\code{\link{summarise.SpatVector}()}
}
\concept{dplyr.cols}
\concept{dplyr.methods}
