% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treatment-effects-posterior.R
\name{treatment_effects.default}
\alias{treatment_effects.default}
\title{Get treatment effect draws from posterior}
\usage{
\method{treatment_effects}{default}(
  model,
  treatment,
  newdata,
  subset = "all",
  common_support_method,
  cutoff,
  ...
)
}
\arguments{
\item{model}{A supported Bayesian model fit that can provide fits and predictions.}

\item{treatment}{A character string specifying the name of the treatment variable.}

\item{newdata}{Data frame to generate fitted values from. If omitted, defaults to the data used to fit the model.}

\item{subset}{Either "treated", "nontreated", or "all". Default is "all".}

\item{common_support_method}{Either "sd", or "chisq". Default is unspecified, and no common support calculation is done.}

\item{cutoff}{Cutoff for common support (if in use).}

\item{...}{Arguments to be passed to \code{tidybayes::fitted_draws} typically scale for \code{BART} models.}
}
\value{
A tidy data frame (tibble) with treatment effect values.
}
\description{
CTE = Conditional Treatment Effects (or CATE, the average effects)
\code{newdata} specifies the conditions, if unspecified it defaults to the original data.
Assumes treated column is either a integer column of 1's (treated) and 0's (nontreated) or logical indicating treatment if TRUE.
}
