% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpcstats.R
\name{simulated}
\alias{simulated}
\alias{simulated.tidyvpcobj}
\title{observed}
\usage{
simulated(o, ...)

\method{simulated}{tidyvpcobj}(o, data, ysim, ...)
}
\arguments{
\item{o}{tidyvpcobj}

\item{...}{other arguments}

\item{data}{data.frame or data.table of simulated data}

\item{ysim}{numeric y-variable, typically named DV}
}
\value{
A \code{tidyvpcobj} containing simulated dataset \code{sim} formatted with columns \code{x}, \code{y}, and \code{repl} which indicates the replicate number.
 The column \code{x} is used from the \code{observed()} function. Resulting dataset is of class \code{data.frame} and \code{data.table}.
}
\description{
Specify simulated dataset and variables for VPC
}
\details{
The simulated function is the second function in the vpc piping chain and is used for specifying simulated data and variables for VPC
}
\examples{
vpc <- observed(obs_data, x=TIME, y=DV) \%>\%
    simulated(sim_data, y=DV) 
    
}
\seealso{
\code{\link{observed}} \code{\link{censoring}} \code{\link{stratify}} \code{\link{predcorrect}} \code{\link{binning}} \code{\link{binless}} \code{\link{vpcstats}}
}
