% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvect_o3.R
\name{solvect_o3_once}
\alias{solvect_o3_once}
\title{Apply `solvect_o3` to a data frame and create new columns with ct and log removals.}
\usage{
solvect_o3_once(
  df,
  input_water = "defined_water",
  time = 0,
  dose = 0,
  kd = 0,
  baffle = 0,
  water_prefix = TRUE
)
}
\arguments{
\item{df}{a data frame containing a water class column, which has already been computed using \code{\link{define_water_chain}}}

\item{input_water}{name of the column of Water class data to be used as the input for this function. Default is "defined_water".}

\item{time}{Retention time of disinfection segment in minutes.}

\item{dose}{Ozone dose (mg/L as O3). This value can also be the y intercept of the decay curve (often slightly lower than ozone dose.)}

\item{kd}{First order decay constant. This parameter is optional. If not specified, the default ozone decay equations will be used.}

\item{baffle}{Baffle factor - unitless value between 0 and 1.}

\item{water_prefix}{name of the input water used for the calculation will be appended to the start of output columns. Default is TRUE.}
}
\value{
A data frame containing the original data frame and columns for required CT, actual CT, and giardia log removal.
}
\description{
This function allows \code{\link{solvect_o3}} to be added to a piped data frame.
Three additional columns will be added to the data frame; ct_required (mg/L*min), ct_actual (mg/L*min), glog_removal
}
\details{
The data input comes from a `water` class column, initialized in \code{\link{define_water_chain}}.

 For large datasets, using `fn_once` or `fn_chain` may take many minutes to run. These types of functions use the furrr package
 for the option to use parallel processing and speed things up. To initialize parallel processing, use
 `plan(multisession)` or `plan(multicore)` (depending on your operating system) prior to your piped code with the
 `fn_once` or `fn_chain` functions. Note, parallel processing is best used when your code block takes more than a minute to run,
 shorter run times will not benefit from parallel processing.
}
\examples{
library(dplyr)
ct_calc <- water_df \%>\%
  define_water_chain() \%>\%
  solvect_o3_once(dose = 2, kd = -0.5, time = 10)

ozone_resid <- water_df \%>\%
  mutate(br = 50) \%>\%
  define_water_chain() \%>\%
  mutate(
    dose = rep(seq(1, 4, 1), 3),
    time = rep(seq(2, 8, 2), 3),
    baffle = .5
  ) \%>\%
  solvect_o3_once()

}
