% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvedose_ph_alk.R
\name{solvedose_ph}
\alias{solvedose_ph}
\title{Calculate a desired chemical dose for a target pH}
\usage{
solvedose_ph(water, target_ph, chemical)
}
\arguments{
\item{water}{Source water of class "water" created by \code{\link{define_water}}}

\item{target_ph}{The final pH to be achieved after the specified chemical is added.}

\item{chemical}{The chemical to be added. Current supported chemicals include:
acids: "hcl", "h2so4", "h3po4", "co2"; bases: "naoh", "na2co3", "nahco3", "caoh2", "mgoh2"}
}
\value{
A numeric value for the required chemical dose.
}
\description{
\code{solvedose_ph} calculates the required amount of a chemical to dose based on a target pH and existing water quality.
The function takes an object of class "water" created by \code{\link{define_water}}, and user-specified chemical and target pH
and returns a numeric value for the required dose in mg/L.

\code{solvedose_ph} uses \code{uniroot} on \code{\link{chemdose_ph}} to match the required dose for the requested pH target.
}
\examples{
water <- define_water(ph = 7, temp = 25, alk = 10)

# Calculate required dose of lime to reach pH 8
solvedose_ph(water, target_ph = 8, chemical = "caoh2")

}
\seealso{
\code{\link{define_water}}, \code{\link{chemdose_ph}}
}
