% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_search.R
\name{tw_search_item}
\alias{tw_search_item}
\title{Search for Wikidata properties in Wikidata and return Wikidata id, label, and description.}
\usage{
tw_search_item(
  search,
  language = tidywikidatar::tw_get_language(),
  limit = 10,
  include_search = FALSE,
  wait = 0,
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = cache_connection
)
}
\arguments{
\item{search}{A string to be searched in Wikidata}

\item{language}{Language to be used for the search. Can be set once per session with \code{tw_set_language()}. If not set, defaults to "en". For a full list, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{limit}{Maximum numbers of responses to be given.}

\item{include_search}{Logical, defaults to FALSE. If TRUE, the search is returned as an additional column.}

\item{wait}{In seconds, defaults to 0.1. Time to wait between queries to Wikidata. If data are cached locally, wait time is not applied.}

\item{cache}{Defaults to NULL. If given, it should be given either TRUE or FALSE. Typically set with \code{tw_enable_cache()} or \code{tw_disable_cache()}.}

\item{overwrite_cache}{Defaults to FALSE. If TRUE, overwrites cache.}

\item{cache_connection}{Defaults to NULL. If NULL, and caching is enabled, \code{tidywikidatar} will use a local sqlite database. A custom connection to other databases can be given (see vignette \code{caching} for details).}
}
\value{
A data frame (a tibble) with three columns (id, label, and description), and as many rows as there are results (by default, limited to 10).
}
\description{
This search returns only items, use \code{tw_search_property()} for properties.
}
\examples{
tw_search_item(search = "Sylvia Pankhurst")
}
