% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlsx_validation.R
\name{xlsx_validation}
\alias{xlsx_validation}
\title{Import data validation rules of cells in xlsx (Excel) files}
\usage{
xlsx_validation(path, sheets = NA)
}
\arguments{
\item{path}{Path to the xlsx file.}

\item{sheets}{Sheets to read. Either a character vector (the names of the
sheets), an integer vector (the positions of the sheets), or NA (default, all
sheets).}
}
\value{
A data frame with the following columns.
\itemize{
\item \code{sheet} The worksheet that a validation rule cell is from.
\item \code{ref} Comma-delimited cell addresses to which the rules apply,
e.g. \code{A106} or A115,A121:A122`.
\item \verb{type Data type of input, one of }whole\verb{, }decimal\verb{, }list\verb{, }date\verb{, }time\verb{, }textLength\verb{, }custom\verb{, and }whole`.
\item \code{operator} Unless \code{type} is \code{list} or \code{custom}, then \code{operator} is one of
\code{between}, \code{notBetween}, \code{equal}, \code{notEqual}, \code{greaterThan}, \code{lessThan},
\code{greaterThanOrEqual}, \code{lessthanOrEqual}.
\item \code{formula1} If \code{type} is \code{list}, then a range of cells whose values are
allowed by the rule.  If \code{type} is \code{custom}, then a formula to determine
allowable values.  Otherwise, a cell address or constant, coerced to
character.  Dates and times are formatted like "2017-01-27 13:30:45".
Times without dates are formatted like "13:30:45".
\item \code{formula2} If \code{operator} is \code{between} or \code{notBetween}, then a cell address
or constant as with formula1, otherwise NA.
\item \code{allow_blank} Boolean, whether or not the rule allows blanks.
\item \code{show_input_message} Boolean, whether or not the rule shows a message when
the user begins entering a value.
\item \code{prompt_title} Text to appear in the title bar of a popup message box
when the user begins entering a value.
\item \code{prompt_body} Text to appear in a popup message box when the user begins
entering a value.  When \code{NA}, then some default text is shown.
\item \code{show_error_message} Boolean, whether or not the rule shows a message when
the user has entered a forbidden value.  When \code{NA}, then some default
text is shown.
\item \code{error_title} Text to appear in the title bar of a popup message box
when the user enters a forbidden value.  When \code{NA}, then some default
text is shown.
\item \code{error_body} Text to appear in a popup message box when the user enters a
forbidden value.  When \code{NA}, then some default text is shown.
\item \code{error_symbol} Name of a symbol to appear in the popup error message when
the user enters a forbidden value.
}
}
\description{
\code{xlsx_validation()} returns the data validation rules applied to cells in
xlsx (Excel) files.  Data validation rules control what constants can be
entered into a cell, e.g. any whole number between 0 and 9, or one of several
values from another part of the spreadsheet.
}
\examples{
examples <- system.file("extdata/examples.xlsx", package = "tidyxl")
xlsx_validation(examples)
xlsx_validation(examples, 1)
xlsx_validation(examples, "Sheet1")
}
