\name{aalen.test}
\alias{aalen.test}
\title{Fit additive hazards model}
\description{
Fits both the additive hazards model of Aalen and the 
semi-parametric additive hazards model of McKeague and Sasieni. 
Estimates are un-weighted. 
Time dependent variables and counting process data 
(multiple events per subject) are possible.

Resampling is used for computing p-values for tests of
time-varying effects. 

The modelling formula uses the standard survival modelling given in the 
\bold{survival} package.
}
\usage{
aalen.test(formula,data=sys.parent(),start.time=0,max.time=NULL,robust=1,
id=NULL,clusters=NULL,residuals=0,n.sim=1000,weighted.test=0,
covariance=0,resample.iid=0,weights=0,offsets=0,fix.gam=0,pseudo.score=0,
approx = "dt", gamma = 0)
}
\arguments{
  \item{formula}{
    a formula object with the response on the left of a '~' operator,
    and the independent terms on the right as regressors. The response
    must be a survival object as returned by the `Surv'
    function. Time-invariant regressors are specified by the wrapper
    const(), and cluster variables (for computing robust variances) by
    the wrapper cluster().
}
\item{data}{
a data.frame with the variables.
}
\item{start.time}{start of observation period where estimates are computed.}
\item{max.time}{end of observation period where estimates are computed. 
Estimates thus computed from [start.time, max.time]. Default is max of data.}
\item{robust}{to compute robust variances and construct processes for
resampling. May be set to 0 to save memory.}
\item{id}{For timevarying covariates the variable must 
associate each record with the id of a subject.}
\item{clusters}{cluster variable for computation of robust 
variances.}
\item{n.sim}{number of simulations in resampling.}
\item{weighted.test}{to compute a variance weighted version of the 
test-processes used for testing
time-varying effects.}
\item{residuals}{to returns residuals that can be used for
model validation in the function cum.residuals
}
\item{covariance}{to compute covariance estimates for
nonparametric terms rather than just the variances.}
\item{resample.iid}{to return i.i.d. representation for
nonparametric and parametric terms.}
\item{offsets}{fixed intensity only works for semiparametric, model
but fully non-parametric model can be fitted by using fix.gam
option, see also example.}
\item{weights}{weights for estimation.}
\item{fix.gam}{keep gamma parameter fixed.}
\item{pseudo.score}{number of simulation for pseudo-score test.
If pseudo.score=0 it is not computed. 
The pseudo-score test for fixed effects 
appears to be superior to other tests computed.

The semiparametric model is given as
\deqn{
\lambda(t) = Y_i(t) (  X_i^t \beta(t) + Z_i^T \gamma ) 
}
then the pseudo-score test is based on  considering the test-process
\deqn{
\tilde U (t)  =  \int_0^t Z^T H dN - \int_0^t Z^T H Z dt
( \int_0^\tau Z^T H Z dt )^{-1} \int_0^t Z^T H dN 
 }
that can be motivated as a pseudo-score test, with notation as
in Martinussen and Scheike (2006), see references. 
}
\item{approx}{describes how the integrals are approximated, "dt" is default and uses a piececonstant approximation for all time points both censoring and event tiems, "death-times" uses only the event times for the approximation.}
\item{gamma}{values for potential fixed gamma coefficients.}
}
\details{
The data for a subject is presented as multiple rows or 'observations',
each of which applies to an interval of observation (start, stop]. 
For counting process data with the )start,stop] notation is used
the 'id' variable is needed to identify the records for each subject.
The program assumes that there are no ties, and if such are present 
random noise is added to break the ties.
}
\value{
returns an object of type "aalen". With the following arguments:
\item{cum}{cumulative timevarying regression coefficient estimates are 
computed within the estimation interval.
}
\item{var.cum}{the martingale based pointwise variance estimates for 
cumulatives.}
\item{robvar.cum}{robust pointwise variances estimates for cumulatives.}
\item{gamma}{estimate of parametric components of model.  }
\item{var.gamma}{variance for gamma.  }
\item{robvar.gamma}{robust variance for gamma.  }
\item{residuals}{list with residuals. Estimated martingale increments (dM) and
corresponding time vector (time).}
\item{obs.testBeq0}{observed absolute value of supremum of 
cumulative components scaled with the variance.}
\item{pval.testBeq0}{p-value for covariate effects based on supremum test.}
\item{sim.testBeq0}{resampled supremum values.}
\item{obs.testBeqC}{observed absolute value of supremum of 
difference between observed cumulative
process and estimate under null of constant effect.}
\item{pval.testBeqC}{p-value based on resampling.}
\item{sim.testBeqC}{resampled supremum values.}
\item{obs.testBeqC.is}{observed integrated squared differences between 
observed cumulative and estimate under null of constant effect.}
\item{pval.testBeqC.is}{p-value based on resampling.}
\item{sim.testBeqC.is}{resampled supremum values.}
\item{conf.band}{resampling based constant to construct robust 95\% uniform 
confidence bands. }
\item{test.procBeqC}{observed test-process of 
difference between observed cumulative 
process and estimate under null of constant effect over time. 
}
\item{sim.test.procBeqC}{list of 50 random realizations of
test-processes under null based on resampling.}
\item{covariance}{covariances for nonparametric terms of model.}
\item{B.iid}{Resample processes for nonparametric terms of model.}
\item{gamma.iid}{Resample processes for parametric terms of model.}
\item{deviance}{Two components : first component "likelihood"
equivalent to partial likelihood for Cox's model, 
second component sum of least squares of increments.}
\item{intZHZ}{computes the integral int ZHZ dt.}
\item{intZHdN}{computes the integral int ZH dN.}
\item{obs.pscore}{pseudo score test value.}
\item{pscore.iid}{iid decomposition of pseudo-score test.}
\item{intZHZt}{computes the integral int ZHZ dt over time.}
\item{pstest.pval}{pseudo-score p-value.}
\item{sup.pscore}{simulated supremum values for pseudo-score test.}
}
\references{
Martinussen and Scheike, Dynamic Regression Models for Survival Data, 
Springer (2006). 

Martinussen and Scheike (200.), 
Tests for time-varying effects within Aalen's additive hazards
model, 
}
\author{Thomas Scheike}
\examples{
library(survival)
data(mela.pop)
# Fits Aalen model  with offsets 
dummy<-rnorm(nrow(mela.pop)); 

out<-aalen.test(Surv(start,stop,status==1)~age+sex+const(dummy),
mela.pop,max.time=7,n.sim=500,offsets=mela.pop$rate,id=mela.pop$id,
fix.gam=1)

summary(out)
par(mfrow=c(2,3))
plot(out)

# Fits semi-parametric additive hazards model  with offsets 
out<-aalen.test(Surv(start,stop,status==1)~age+const(sex),
mela.pop,max.time=7,n.sim=500,offsets=mela.pop$rate,id=mela.pop$id)

summary(out)
plot(out)

################################################################
# Computes pseudo.score tests for fixed effects 
data(sTRACE)
out<-aalen.test(Surv(time,status==9)~const(age)+const(sex)+const(diabetes)+
chf+vf,sTRACE,max.time=7,n.sim=500,pseudo.score=500)

summary(out)
}
\keyword{survival}
