% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_pos.R
\name{oc_pos}
\alias{oc_pos}
\title{Assessing probability of success}
\usage{
oc_pos(
  m,
  se,
  probs,
  weights = seq(0, 1, by = 0.01),
  map_prior,
  sigma,
  null_effect = 0,
  direction_pos = T,
  n_cores = 1,
  eval_strategy = "sequential"
)
}
\arguments{
\item{m}{Numerical vector of simulated effect estimates.}

\item{se}{Numerical vector of simulated standard errors (\code{m} and \code{se} need to have the same length).}

\item{probs}{Vector of quantiles q, with 1 minus q representing an evidence level of interest (where positive effect estimate indicate a beneficial treatment).}

\item{weights}{Vector of weights of the informative component of the MAP prior (defaults to \code{seq(0, 1, by = 0.01)}).}

\item{map_prior}{A MAP prior containing information about the trials in the source population, created using \code{RBesT}; a mixture of normal distributions is required.}

\item{sigma}{Standard deviation of the weakly informative component of the MAP prior, recommended to be the unit-information standard deviation.}

\item{null_effect}{Numerical value, representing the null effect (defaults to 0).}

\item{direction_pos}{Logical value, \code{TRUE} (default) if effects greater that the \code{null_effect} indicate a beneficial treatment and \code{FALSE} otherwise.}

\item{n_cores}{Integer value, representing the number of cores to be used (defaults to 1); only applies if \code{eval_strategy} is not "sequential".}

\item{eval_strategy}{Character variable, representing the evaluation strategy, either "sequential", "multisession", or "multicore" (see documentation of \code{future::plan}, defaults to "sequential").}
}
\value{
A 2-dimensional array containing probabilities, either of truly (probability of success) or falsely rejecting the null hypothesis of interest for a given weight and evidence level.
}
\description{
Assessment of the probability of truly or falsely (depending on simulated scenario) rejecting the null hypothesis of interest for a given weight and evidence level, using simulated data as input.
}
\examples{
set.seed(123)
n_sims <- 5 # small number for exemplary application
sim_dat <- list(
  "m" = rnorm(n = n_sims, mean = 1.15, sd = 0.1),
  "se" = rnorm(n = n_sims, mean = 1.8, sd = 0.3)
)
results <- oc_pos(
  m = sim_dat[["m"]],
  se = sim_dat[["se"]],
  probs = c(0.025, 0.05, 0.1, 0.2), 
  weights = seq(0, 1, by = 0.01), 
  map_prior = load_tipmap_data("tipmapPrior.rds"), 
  sigma = 16.23,
  null_effect = 0,
  direction_pos = TRUE, 
  eval_strategy = "sequential",
  n_cores = 1
) 
print(results)
}
\seealso{
\code{\link{oc_bias}} and \code{\link{oc_coverage}}.
}
