% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tippy.R
\name{tippy}
\alias{tippy}
\alias{tippy_this}
\title{Create a tooltip}
\usage{
tippy(text, tooltip, ..., width = NULL, height = NULL, elementId = NULL)

tippy_this(elementId, tooltip, ...)
}
\arguments{
\item{text}{Element text.}

\item{tooltip}{Element tooltip.}

\item{...}{Any other options from \href{https://github.com/atomiks/tippyjs#options}{the official documentation}.}

\item{height, width}{height and width of sparkline htmlwidget
specified in any valid \code{CSS} size unit.}

\item{elementId}{\code{string} id as a valid \code{CSS} element id.}
}
\description{
Add tooltips to your document.
}
\examples{
tippy("Hover me!", tooltip = "Hi, I'm the tooltip!")
tippy("Hover me!", tooltip = "Hi, I'm the tooltip!", placement = "right",
  theme = "light")
tippy("Hover me!", tooltip = "Hi, I'm the tooltip!", animation = "scale",
  duration = 1000, placement = "bottom")
tippy("Click me!", tooltip = "Hi, I'm the tooltip!", trigger = "click",
  theme = "light")

# use tooltip on other elements.
if(interactive()){
library(shiny)

shinyApp(
  ui = fluidPage(
    textInput("input", "input with tooltip"),
    tippy("Some text", tooltip = "Tiiiip"),
    tippy_this("input", "Tooltip", placement = "right")
 ),
 server = function(input, output) {}
)
}

}
\seealso{
\href{https://atomiks.github.io/tippyjs/}{official documentation}
}
