% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export}
\alias{export}
\title{Exporting Results of a Small Area Model Fitting}
\usage{
export(x, file, type = "all", ...)
}
\arguments{
\item{x}{An object of class \code{estimates_fitsae}.}

\item{file}{A character string indicating the path (if different from the working directory) and filename of the CSV to be created. It should end with .csv.}

\item{type}{An option between \code{"in"}, \code{"out"} and \code{"all"}, indicating whether to export only in or out-of-sample areas or both.}

\item{...}{Additional arguments of \code{\link[utils]{write.csv}} function from \code{utils} package can be indicated.}
}
\value{
A CSV file is created in the working directory, or at the given path, exporting the \code{estimates_fitsae} object given as input.
}
\description{
The function \code{export()} allows for exporting model estimates in CSV format.
}
\examples{
\dontrun{
library(tipsae)

# loading toy dataset
data("emilia_cs")

# fitting a model
fit_beta <- fit_sae(formula_fixed = hcr ~ x, data = emilia_cs, domains = "id",
                    type_disp = "var", disp_direct = "vars", domain_size = "n",
                    seed = 0)

# check model diagnostics
summ_beta <- summary(fit_beta)

# extract model estimates
HB_estimates <- extract(summ_beta)

# export model estimates
export(HB_estimates, file = "results.csv", type = "all")
}


}
\seealso{
\code{\link{extract}} to produce the input object and \code{\link[utils]{write.csv}}.
}
