% Generated by roxygen2 (4.0.1): do not edit by hand
\name{fit_polylines}
\alias{fit_polylines}
\title{Fit polylines through a set of spatial points}
\usage{
fit_polylines(..., id = NULL, min.dist = 10, max.opt.dist = 250,
  sep.dist = 5000, verbose = TRUE)
}
\arguments{
\item{...}{Shape objects that contains the spatial points.}

\item{id}{Name of the data variable that determines the classes of the points. For each class a polyline is fit. Is omitted, a polyline is fit through all points.}

\item{min.dist}{Minimum distance. Poins that are closer than \code{min.dist} from any other point are omitted in the fitting method (see details below)}

\item{max.opt.dist}{Maximal optimized distance. Between any two points that lie closer than
\code{max.opt.dist} to each other, an edge is created in the fitting method (see details below)}

\item{sep.dist}{Seperation distance. If the distance between two groups of points is larger than \code{sep.dist}, two seperate polylines are created.}

\item{verbose}{Print logging text}
}
\value{
SpatialLinesDataframe
}
\description{
This function fits one or more smooth polylines through a set of spatial points. (Experimental)
}

