% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_misc_elements.R
\name{tm_scale_bar}
\alias{tm_scale_bar}
\title{Scale bar}
\usage{
tm_scale_bar(breaks = NULL, width = 0.25, size = 0.5, text.color = NA,
  color.dark = "black", color.light = "white", lwd = 1, position = NA)
}
\arguments{
\item{breaks}{breaks of the scale bar. If not specified, breaks will be automatically be chosen given the prefered \code{width} of the scale bar.}

\item{width}{(prefered) width of the scale bar. Only applicable when \code{breaks=N ULL}}

\item{size}{relative text size (which is upperbound by the available label width)}

\item{text.color}{color of the text. By default equal to the argument \code{attr.color} of \code{\link{tm_layout}}.}

\item{color.dark}{color of the dark parts of the scale bar, typically (and by default) black.}

\item{color.light}{color of the light parts of the scale bar, typically (and by default) white.}

\item{lwd}{line width of the scale bar}

\item{position}{position of the text. Vector of two values, specifing the x and y coordinates. Either this vector contains "left", "LEFT", "center", "right", or "RIGHT" for the first value and "top", "TOP", "center", "bottom", or "BOTTOM" for the second value, or this vector contains two numeric values between 0 and 1 that specifies the x and y value of the left bottom corner of the scale bar. The uppercase values correspond to the position without margins (so tighter to the frame). The default value is controlled by the argument \code{"attr.position"} of \code{\link{tm_layout}}.}
}
\description{
Creates a scale bar. By default, the coordinate units are assumed to be meters, and the map units in kilometers. This can be changed in \code{\link{tm_shape}}.
}
\examples{
current.mode <- tmap_mode("plot")

data(NLD_muni)
qtm(NLD_muni, theme = "NLD") + tm_scale_bar(position=c("left", "bottom"))

data(Europe)
tm_shape(Europe, unit = "miles", unit.size=1609) + 
	tm_polygons() + 
tm_scale_bar()  + tm_layout(attr.outside = TRUE)

# restore current mode
tmap_mode(current.mode)
}

