% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_raster.R
\name{poly_to_raster}
\alias{poly_to_raster}
\title{Convert spatial polygons to a raster}
\usage{
poly_to_raster(shp, r = NULL, nrow = NA, ncol = NA, N = 250000,
  use.cover = FALSE, copy.data = FALSE, to.Raster = NULL, ...)
}
\arguments{
\item{shp}{shape object. A \code{\link[sp:SpatialPointsDataFrame]{SpatialPoints(DataFrame)}}, a \code{\link[sp:SpatialGridDataFrame]{SpatialGrid(DataFrame)}}, or an \code{sf} object that can be coerced as such.}

\item{r}{\code{\link[raster:raster]{Raster}} object. If not specified, it will be created from the bounding box of \code{shp} and the arguments \code{N}, \code{nrow}, and \code{ncol}.}

\item{nrow}{number of raster rows. If \code{NA}, it is automatically determined by \code{N} and the aspect ratio of \code{shp}.}

\item{ncol}{number of raster columns. If \code{NA}, it is automatically determined by \code{N} and the aspect ratio of \code{shp}.}

\item{N}{preferred number of raster cells.}

\item{use.cover}{logical; should the cover method be used? This method determines per raster cell which polygon has the highest cover fraction. This method is better, but very slow, since N times the number of polygons combinations are processed (using the \code{getCover} argument of \code{\link[raster:rasterize]{rasterize}}). By default, when a raster cell is covered by multiple polygons, the last polygon is taken (see \code{fun} argment of \code{\link[raster:rasterize]{rasterize}}))}

\item{copy.data}{should the polygon data be appended to the raster? Only recommended when \code{N} is small.}

\item{to.Raster}{not used anymore, since the "raster" output is always a \code{\link[raster:Raster-class]{RasterLayer}} as of version 2.0}

\item{...}{arguments passed on to \code{\link[raster:rasterize]{rasterize}}}
}
\value{
a \code{RasterBrick} is returned when \code{by} is specified, and a \code{RasterLayer} when \code{by} is unspecified
}
\description{
Convert spatial polygons to a raster. The value of each raster cell will be the polygon ID number. Alternatively, if \code{copy.data}, the polygon data is appended to each raster cell.
}
\examples{
\dontrun{
if (require(tmap)) {
    data(NLD_muni)

    # choropleth of 65+ population percentages
    qtm(NLD_muni, fill="pop_65plus", format="NLD")

    # rasterized version
    NLD_rst <- poly_to_raster(NLD_muni, copy.data = TRUE)
    qtm(NLD_rst, raster="pop_65plus", format="NLD")
}
}
}
\seealso{
\code{\link{points_to_raster}}
}
