% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.group_tna_stability}
\alias{print.group_tna_stability}
\title{Print Centrality Stability Results}
\usage{
\method{print}{group_tna_stability}(x, ...)
}
\arguments{
\item{x}{A \code{group_tna_stability} object.}

\item{...}{Arguments passed to \code{\link[=print.tna_stability]{print.tna_stability()}}.}
}
\value{
\code{x} (invisibly).
}
\description{
Print Centrality Stability Results
}
\examples{
model <- group_model(engagement_mmm)
# Low number of iterations for CRAN
stability <- estimate_cs(
  model,
  drop_prop = c(0.3, 0.5, 0.7, 0.9),
  iter = 10
)
print(stability)

}
\seealso{
Cluster-related functions
\code{\link{bootstrap}()},
\code{\link{centralities}()},
\code{\link{cliques}()},
\code{\link{communities}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{group_model}()},
\code{\link{hist.group_tna}()},
\code{\link{mmm_stats}()},
\code{\link{plot.group_tna}()},
\code{\link{plot.group_tna_centralities}()},
\code{\link{plot.group_tna_cliques}()},
\code{\link{plot.group_tna_communities}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{print.group_tna}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_centralities}()},
\code{\link{print.group_tna_cliques}()},
\code{\link{print.group_tna_communities}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{rename_groups}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna}()},
\code{\link{summary.group_tna_bootstrap}()}
}
\concept{clusters}
