% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_frequencies.group_tna}
\alias{plot_frequencies.group_tna}
\title{Plot the Frequency Distribution of States}
\usage{
\method{plot_frequencies}{group_tna}(x, label, ...)
}
\arguments{
\item{x}{A \code{group_tna} object.}

\item{label}{An optional \code{character} string that can be provided to specify
the grouping factor name if \code{x} was not constructed using a column name of
the original data.}

\item{...}{Ignored.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the Frequency Distribution of States
}
\examples{
model <- group_model(engagement_mmm)
plot_frequencies(model)

}
\seealso{
Basic functions
\code{\link{build_model}()},
\code{\link{hist.group_tna}()},
\code{\link{hist.tna}()},
\code{\link{import_data}()},
\code{\link{plot.group_tna}()},
\code{\link{plot.tna}()},
\code{\link{plot_frequencies}()},
\code{\link{plot_mosaic}()},
\code{\link{plot_mosaic.group_tna}()},
\code{\link{plot_mosaic.tna_data}()},
\code{\link{prepare_data}()},
\code{\link{print.group_tna}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.tna}()},
\code{\link{print.tna}()},
\code{\link{print.tna_data}()},
\code{\link{simulate.tna}()},
\code{\link{summary.group_tna}()},
\code{\link{summary.tna}()},
\code{\link{tna-package}}
}
\concept{basic}
