% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-proxy.R
\name{cal_proxy_view}
\alias{cal_proxy_view}
\title{Change calendar view with Proxy}
\usage{
cal_proxy_view(proxy, view)
}
\arguments{
\item{proxy}{A \code{\link[=calendar_proxy]{calendar_proxy()}} \code{htmlwidget} object.}

\item{view}{The new view for the calendar: "day", "week" or "month".}
}
\value{
A \code{calendar_proxy} object.
}
\description{
This function allow to change the calendar view from the server in a Shiny application.
}
\examples{
library(shiny)

ui <- fluidPage(
  tags$h2("Change calendar view"),
  radioButtons(
    inputId = "view",
    label = "Change view:",
    choices = c("day", "week", "month"),
    inline = TRUE
  ),
  calendarOutput(outputId = "my_calendar")
)

server <- function(input, output, session) {

  output$my_calendar <- renderCalendar({
    calendar(view = "day", scheduleView = "allday") \%>\%
      cal_schedules(
        title = "Today planning",
        start = Sys.Date(),
        end = Sys.Date(),
        category = "allday"
      )
  })

  observeEvent(
    input$view,
    cal_proxy_view("my_calendar", input$view),
    ignoreInit = TRUE
  )

}


if (interactive())
  shinyApp(ui, server)
}
\seealso{
Other calendar proxy methods: 
\code{\link{cal_proxy_clear}()},
\code{\link{cal_proxy_options}()},
\code{\link{cal_proxy_toggle}()},
\code{\link{calendar-proxy-navigate}},
\code{\link{calendar-proxy-schedule}},
\code{\link{calendar_proxy}()}
}
\concept{calendar proxy methods}
