% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_temporal_mapping}
\alias{plot_temporal_mapping}
\title{Create Temporal Mapping Plot}
\usage{
plot_temporal_mapping(
  df_coords,
  ndim,
  dim_config = new_dim_reduction_config(),
  aesthetic_config = new_aesthetic_config(),
  layout_config = new_layout_config(),
  annotation_config = new_annotation_config(),
  output_dir,
  show_shape_legend = TRUE,
  draw_arrows = FALSE,
  annotate_arrows = TRUE,
  phylo_tree = NULL,
  sigma_t = NULL,
  sigma_x = NULL,
  clade_node_depth = NULL
)
}
\arguments{
\item{df_coords}{Data frame containing:
- V1, V2, ... Vn: Coordinate columns
- antigen: Binary indicator for antigen points
- antiserum: Binary indicator for antiserum points
- year: Numeric year values for temporal coloring}

\item{ndim}{Number of dimensions in input coordinates}

\item{dim_config}{Dimension reduction configuration object specifying method and parameters}

\item{aesthetic_config}{Aesthetic configuration object controlling plot appearance}

\item{layout_config}{Layout configuration object controlling plot dimensions and style.
Use x_limits and y_limits in layout_config to set axis limits.}

\item{annotation_config}{Annotation configuration object for labeling notable points}

\item{output_dir}{Character. Directory for output files. Required if \code{layout_config$save_plot} is \code{TRUE}.}

\item{show_shape_legend}{Logical. Whether to show the shape legend (default: TRUE)}

\item{draw_arrows}{logical; if TRUE, compute and draw antigenic drift vectors}

\item{annotate_arrows}{logical; if TRUE, show names of the points having arrows}

\item{phylo_tree}{Optional; phylo object in Newick format. Does not need to be rooted. If provided, used to compute antigenic velocity arrows.}

\item{sigma_t}{Optional; numeric; bandwidth for the Gaussian kernel discounting on time in years or the time unit of the data. If NULL, uses Silverman's rule of thumb.}

\item{sigma_x}{Optional; numeric; bandwidth for the Gaussian kernel discounting on antigenic distancein antigenic units. If NULL, uses Silverman's rule of thumb.}

\item{clade_node_depth}{Optional; integer; number of levels of parent nodes to define clades. Antigens from different clades will be excluded from the calculation antigenic velocity arrows. (Default: Automatically calculated mode of leaf-to-backbone distance of the tree)}
}
\value{
A \code{ggplot} object containing the temporal mapping visualization.
}
\description{
Creates a visualization of points colored by time (year) using dimension reduction, with optional antigenic velocity arrows.
Points are colored on a gradient scale based on their temporal values, with
different shapes for antigens and antisera.
}
\details{
The function performs these steps:
\enumerate{
\item Validates input data structure and types
\item Applies dimension reduction if ndim > 2
\item Creates visualization with temporal color gradient
\item Applies specified aesthetic and layout configurations
\item Applies custom axis limits if specified in layout_config
}

Different shapes distinguish between antigens and antisera points, while
color represents temporal progression.
}
\examples{
# Basic usage with default configurations
data <- data.frame(
  V1 = rnorm(100), V2 = rnorm(100), V3 = rnorm(100), name = 1:100,
  antigen = rep(c(0,1), 50), antiserum = rep(c(1,0), 50),
  year = rep(2000:2009, each=10)
)
# Plot without saving
p1 <- plot_temporal_mapping(data, ndim=3)

# Save plot to a temporary directory
temp_dir <- tempdir()
layout_config_save <- new_layout_config(save_plot = TRUE,
                       x_limits = c(-10, 10),
                       y_limits = c(-8, 8))
p_saved <- plot_temporal_mapping(data, ndim = 3, layout_config = layout_config_save, 
                                 output_dir = temp_dir)
list.files(temp_dir) # Check that file was created
unlink(temp_dir, recursive = TRUE) # Clean up

}
\seealso{
\code{\link{plot_cluster_mapping}} for cluster-based visualization
\code{\link{plot_3d_mapping}} for 3D visualization
\code{\link{new_dim_reduction_config}} for dimension reduction options
\code{\link{new_aesthetic_config}} for aesthetic options
\code{\link{new_layout_config}} for layout options
\code{\link{new_annotation_config}} for annotation options
}
