% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_topsa}
\alias{plot_topsa}
\title{plot \code{topsa} objects}
\usage{
plot_topsa(topsaObj, nvar = "all", ...)
}
\arguments{
\item{topsaObj}{an object of class \code{topsa}}

\item{nvar}{it could be a sequence from 1 to the number of variables
indicating which variables should be plotted. It could be the character
'all' for plot all the variables.}

\item{...}{further arguments passed to the \code{plot} function}
}
\value{
A plot of generated with the output of \code{topsa}. For each
variable in the model, it creates the plot of the corresponding manifold, its
symmetric reflection and its symmetric difference.
}
\description{
Plot method for objects of class \code{topsa}.
}
\examples{

ishigami.fun <- function(X) {
A <- 7
B <- 0.1
sin(X[, 1]) + A * sin(X[, 2])^2 + B * X[, 3]^4 * sin(X[, 1])
}

X <- matrix(runif(3*50, -pi, pi), ncol = 3)
Y <- ishigami.fun(X)

estimation <- topsa(Ydat = Y, Xdat = X)

plot_topsa(estimation)
}
