% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-pooling.R
\name{nn_avg_pool2d}
\alias{nn_avg_pool2d}
\title{Applies a 2D average pooling over an input signal composed of several input
planes.}
\usage{
nn_avg_pool2d(
  kernel_size,
  stride = NULL,
  padding = 0,
  ceil_mode = FALSE,
  count_include_pad = TRUE,
  divisor_override = NULL
)
}
\arguments{
\item{kernel_size}{the size of the window}

\item{stride}{the stride of the window. Default value is \code{kernel_size}}

\item{padding}{implicit zero padding to be added on both sides}

\item{ceil_mode}{when TRUE, will use \code{ceil} instead of \code{floor} to compute the output shape}

\item{count_include_pad}{when TRUE, will include the zero-padding in the averaging calculation}

\item{divisor_override}{if specified, it will be used as divisor, otherwise \code{kernel_size} will be used}
}
\description{
In the simplest case, the output value of the layer with input size \eqn{(N, C, H, W)},
output \eqn{(N, C, H_{out}, W_{out})} and \code{kernel_size} \eqn{(kH, kW)}
can be precisely described as:
}
\details{
\deqn{
  out(N_i, C_j, h, w)  = \frac{1}{kH * kW} \sum_{m=0}^{kH-1} \sum_{n=0}^{kW-1}
input(N_i, C_j, stride[0] \times h + m, stride[1] \times w + n)
}

If \code{padding} is non-zero, then the input is implicitly zero-padded on both sides
for \code{padding} number of points.

The parameters \code{kernel_size}, \code{stride}, \code{padding} can either be:
\itemize{
\item a single \code{int} -- in which case the same value is used for the height and width dimension
\item a \code{tuple} of two ints -- in which case, the first \code{int} is used for the height dimension,
and the second \code{int} for the width dimension
}
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, C, H_{in}, W_{in})}
\item Output: \eqn{(N, C, H_{out}, W_{out})}, where
}

\deqn{
  H_{out} = \left\lfloor\frac{H_{in}  + 2 \times \mbox{padding}[0] -
      \mbox{kernel\_size}[0]}{\mbox{stride}[0]} + 1\right\rfloor
}
\deqn{
  W_{out} = \left\lfloor\frac{W_{in}  + 2 \times \mbox{padding}[1] -
      \mbox{kernel\_size}[1]}{\mbox{stride}[1]} + 1\right\rfloor
}
}

\examples{
if (torch_is_installed()) {

# pool of square window of size=3, stride=2
m <- nn_avg_pool2d(3, stride = 2)
# pool of non-square window
m <- nn_avg_pool2d(c(3, 2), stride = c(2, 1))
input <- torch_randn(20, 16, 50, 32)
output <- m(input)
}
}
