% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_selu}
\alias{nn_selu}
\title{SELU module}
\usage{
nn_selu(inplace = FALSE)
}
\arguments{
\item{inplace}{(bool, optional): can optionally do the operation in-place. Default: \code{FALSE}}
}
\description{
Applied element-wise, as:
}
\details{
\deqn{
  \mbox{SELU}(x) = \mbox{scale} * (\max(0,x) + \min(0, \alpha * (\exp(x) - 1)))
}

with \eqn{\alpha = 1.6732632423543772848170429916717} and
\eqn{\mbox{scale} = 1.0507009873554804934193349852946}.

More details can be found in the paper
\href{https://arxiv.org/abs/1706.02515}{Self-Normalizing Neural Networks}.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(N, *)}, same shape as the input
}
}

\examples{
if (torch_is_installed()) {
m <- nn_selu()
input <- torch_randn(2)
output <- m(input)

}
}
