% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_gather}
\alias{torch_gather}
\title{Gather}
\usage{
torch_gather(self, dim, index, sparse_grad = FALSE)
}
\arguments{
\item{self}{(Tensor) the source tensor}

\item{dim}{(int) the axis along which to index}

\item{index}{(LongTensor) the indices of elements to gather}

\item{sparse_grad}{(bool,optional) If \code{TRUE}, gradient w.r.t. \code{input} will be a sparse tensor.}
}
\description{
Gather
}
\section{gather(input, dim, index, sparse_grad=FALSE) -> Tensor }{


Gathers values along an axis specified by \code{dim}.

For a 3-D tensor the output is specified by::\preformatted{out[i][j][k] = input[index[i][j][k]][j][k]  # if dim == 0
out[i][j][k] = input[i][index[i][j][k]][k]  # if dim == 1
out[i][j][k] = input[i][j][index[i][j][k]]  # if dim == 2
}

If \code{input} is an n-dimensional tensor with size
\eqn{(x_0, x_1..., x_{i-1}, x_i, x_{i+1}, ..., x_{n-1})}
and \code{dim = i}, then \code{index} must be an \eqn{n}-dimensional tensor with
size \eqn{(x_0, x_1, ..., x_{i-1}, y, x_{i+1}, ..., x_{n-1})} where \eqn{y \geq 1}
and \code{out} will have the same size as \code{index}.
}

\examples{
if (torch_is_installed()) {

t = torch_tensor(matrix(c(1,2,3,4), ncol = 2, byrow = TRUE))
torch_gather(t, 2, torch_tensor(matrix(c(1,1,2,1), ncol = 2, byrow=TRUE), dtype = torch_int64()))
}
}
