% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_log_softmax}
\alias{nn_log_softmax}
\title{LogSoftmax module}
\usage{
nn_log_softmax(dim)
}
\arguments{
\item{dim}{(int): A dimension along which LogSoftmax will be computed.}
}
\value{
a Tensor of the same dimension and shape as the input with
values in the range [-inf, 0)
}
\description{
Applies the \eqn{\log(\mbox{Softmax}(x))} function to an n-dimensional
input Tensor. The LogSoftmax formulation can be simplified as:
}
\details{
\deqn{
  \mbox{LogSoftmax}(x_{i}) = \log\left(\frac{\exp(x_i) }{ \sum_j \exp(x_j)} \right)
}
}
\section{Shape}{

\itemize{
\item Input: \eqn{(*)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(*)}, same shape as the input
}
}

\examples{
if (torch_is_installed()) {
m <- nn_log_softmax(1)
input <- torch_randn(2, 3)
output <- m(input)

}
}
