% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_sort}
\alias{torch_sort}
\title{Sort}
\usage{
torch_sort(self, dim = -1L, descending = FALSE, stable)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{dim}{(int, optional) the dimension to sort along}

\item{descending}{(bool, optional) controls the sorting order (ascending or descending)}

\item{stable}{(bool, optional) – makes the sorting routine stable, which guarantees
that the order of equivalent elements is preserved.}
}
\description{
Sort
}
\section{sort(input, dim=-1, descending=FALSE) -> (Tensor, LongTensor) }{


Sorts the elements of the \code{input} tensor along a given dimension
in ascending order by value.

If \code{dim} is not given, the last dimension of the \code{input} is chosen.

If \code{descending} is \code{TRUE} then the elements are sorted in descending
order by value.

A namedtuple of (values, indices) is returned, where the \code{values} are the
sorted values and \code{indices} are the indices of the elements in the original
\code{input} tensor.
}

\examples{
if (torch_is_installed()) {

x = torch_randn(c(3, 4))
out = torch_sort(x)
out
out = torch_sort(x, 1)
out
}
}
