% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-loss.R
\name{nn_mse_loss}
\alias{nn_mse_loss}
\title{MSE loss}
\usage{
nn_mse_loss(reduction = "mean")
}
\arguments{
\item{reduction}{(string, optional): Specifies the reduction to apply to the output:
\code{'none'} | \code{'mean'} | \code{'sum'}. \code{'none'}: no reduction will be applied,
\code{'mean'}: the sum of the output will be divided by the number of
elements in the output, \code{'sum'}: the output will be summed.}
}
\description{
Creates a criterion that measures the mean squared error (squared L2 norm) between
each element in the input \eqn{x} and target \eqn{y}.
The unreduced (i.e. with \code{reduction} set to \code{'none'}) loss can be described
as:
}
\details{
\deqn{
  \ell(x, y) = L = \{l_1,\dots,l_N\}^\top, \quad
l_n = \left( x_n - y_n \right)^2,
}

where \eqn{N} is the batch size. If \code{reduction} is not \code{'none'}
(default \code{'mean'}), then:

\deqn{
  \ell(x, y) =
  \begin{array}{ll}
\mbox{mean}(L), &  \mbox{if reduction} = \mbox{'mean';}\\
\mbox{sum}(L),  &  \mbox{if reduction} = \mbox{'sum'.}
\end{array}
}

\eqn{x} and \eqn{y} are tensors of arbitrary shapes with a total
of \eqn{n} elements each.

The mean operation still operates over all the elements, and divides by \eqn{n}.
The division by \eqn{n} can be avoided if one sets \code{reduction = 'sum'}.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \eqn{*} means, any number of additional
dimensions
\item Target: \eqn{(N, *)}, same shape as the input
}
}

\examples{
if (torch_is_installed()) {
loss <- nn_mse_loss()
input <- torch_randn(3, 5, requires_grad = TRUE)
target <- torch_randn(3, 5)
output <- loss(input, target)
output$backward()
}
}
