% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions-poisson.R
\name{distr_poisson}
\alias{distr_poisson}
\title{Creates a Poisson distribution parameterized by \code{rate}, the rate parameter.}
\usage{
distr_poisson(rate, validate_args = NULL)
}
\arguments{
\item{rate}{(numeric, torch_tensor): the rate parameter}

\item{validate_args}{whether to validate arguments or not.}
}
\description{
Samples are nonnegative integers, with a pmf given by
\deqn{
\mbox{rate}^{k} \frac{e^{-\mbox{rate}}}{k!}
}
}
\examples{
if (torch_is_installed()) {
m <- distr_poisson(torch_tensor(4))
m$sample()
}
}
\seealso{
\link{Distribution} for details on the available methods.

Other distributions: 
\code{\link{distr_bernoulli}()},
\code{\link{distr_chi2}()},
\code{\link{distr_gamma}()},
\code{\link{distr_multivariate_normal}()},
\code{\link{distr_normal}()}
}
\concept{distributions}
