% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_phase_vocoder}
\alias{functional_phase_vocoder}
\title{Phase Vocoder}
\usage{
functional_phase_vocoder(complex_specgrams, rate, phase_advance)
}
\arguments{
\item{complex_specgrams}{(Tensor): Dimension of \verb{(..., freq, time, complex=2)}}

\item{rate}{(float): Speed-up factor}

\item{phase_advance}{(Tensor): Expected phase advance in each bin. Dimension of (freq, 1)}
}
\value{
\code{tensor}: Complex Specgrams Stretch with dimension of \verb{(..., freq, ceiling(time/rate), complex=2)}
}
\description{
Given a STFT tensor, speed up in time without modifying pitch by a factor of \code{rate}.
}
\examples{
if(torch::torch_is_installed()) {
library(torch)
library(torchaudio)

freq = 1025
hop_length = 512

#  (channel, freq, time, complex=2)
complex_specgrams = torch_randn(2, freq, 300, 2)
rate = 1.3 # Speed up by 30\%
phase_advance = torch_linspace(0, pi * hop_length, freq)[.., NULL]
x = functional_phase_vocoder(complex_specgrams, rate, phase_advance)
x$shape # with 231 == ceil (300 / 1.3)
# torch.Size ([2, 1025, 231, 2])
}

}
