% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_census_and_acs.R
\name{search_geocomponents}
\alias{search_geocomponents}
\title{Search geographic components}
\usage{
search_geocomponents(survey, keyword = "*", view = TRUE)
}
\arguments{
\item{survey}{"decennial" or "acs"}

\item{keyword}{keyword to search in code or description, "*" for any words.}

\item{view}{display the search result with View if TRUE}
}
\value{
A data.table
}
\description{
Search the code or content of geographic components
}
\details{
The most frequently used geographic components are:

00 : all geographic component

01 : urban

43 : rural
}
\examples{
# Change view = TRUE (default) to View the returned data.
aaa <- search_geocomponents("decennial", "urban", view = FALSE)
bbb <- search_geocomponents("acs", "43", view = FALSE)

\dontrun{
  # view all geocomponents
  search_geocomponents("decennial")
  search_geocomponents("acs")
}

}
