% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeR.R, R/trackeRdata_plot.R,
%   R/trackeRdata_summary.R
\name{timeline}
\alias{timeline}
\alias{timeline.trackeRdata}
\alias{timeline.trackeRdataSummary}
\title{Generic function for visualising the sessions on a time versus date plot}
\usage{
timeline(object, lims, ...)

\method{timeline}{trackeRdata}(object, lims = NULL, ...)

\method{timeline}{trackeRdataSummary}(object, lims = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{\link{trackeRdata}} or
\code{\link{trackeRdataSummary}}.}

\item{lims}{An optional vector of two times in HH:MM
format. Default is \code{NULL} If supplied, the times are used
to define the limits of the time axis.}

\item{...}{Arguments passed to \code{\link{summary.trackeRdata}}.}
}
\description{
Generic function for visualising the sessions on a time versus date plot

Timeline plot for \code{\link{trackeRdata}} objects.

Timeline plot for \code{\link{trackeRdataSummary}} objects
}
\examples{
\dontrun{
data('runs', package = 'trackeR')
## timeline plot applied on the \code{trackeRdata} object directly and with
## inferred limits for the time axis
timeline(runs)

## the same timeline plot applied on the \code{trackeRdataSummary} object
runSummary <- summary(runs)
timeline(runSummary, lims = c('00:01', '23:59'))
}
}
