\name{MriImageMetadata-class}
\Rdversion{1.1}
\docType{class}
\alias{MriImageMetadata}
\alias{MriImageMetadata-class}

\title{Class \code{"MriImageMetadata"}}
\description{
This class represents MRI image metadata. An object of this class contains various information about an image, such as its image and voxel dimensions, coordinate origin and storage data type. An object of type \code{\linkS4class{MriImage}} can be treated as a metadata object, since the latter is embedded in it.
}
\section{Extends}{
Class \code{"\linkS4class{SerialisableObject}"}, directly.

All reference classes extend and inherit methods from \code{"\linkS4class{envRefClass}"}.
}
\author{Jon Clayden}
\references{
Please cite the following reference when using TractoR in your work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A. Clark (2011). TractoR: Magnetic resonance imaging and tractography with R. Journal of Statistical Software 44(8):1-18. URL http://www.jstatsoft.org/v44/i08/.
}
\examples{
showClass("MriImageMetadata")
}
\keyword{classes}
\section{Fields}{
  \describe{
    \item{\code{imagedims}:}{Object of class \code{integer}.}
    \item{\code{voxdims}:}{Object of class \code{numeric}.}
    \item{\code{voxunit}:}{Object of class \code{character}.}
    \item{\code{source}:}{Object of class \code{character}.}
    \item{\code{datatype}:}{Object of class \code{list}.}
    \item{\code{origin}:}{Object of class \code{numeric}.}
    \item{\code{storedXform}:}{Object of class \code{matrix}.}
    \item{\code{tags}:}{Object of class \code{list}.}
  }
}
\section{Class-Based Methods}{
  \describe{
    \item{\code{initialize(imagedims, voxdims, voxunit, source, datatype, origin, storedXform, tags, ...)}:}{Create a new object of this class.}
    \item{\code{summarise()}:}{Retrieve information about this object. This method is usually only called implicitly by the \code{"show"} method.}
    \item{\code{getFieldOfView()}:}{Retrieve the field of view along each dimension, i.e. the product of the image dimensions and voxel dimensions.}
    \item{\code{getDimensions()}:}{Retrieve an integer vector giving the dimensions of the image in voxels.}
    \item{\code{getDimensionality()}:}{Retrieve an integer vector of length 1 giving the number of dimensions in the image.}
    \item{\code{getVoxelDimensions()}:}{Retrieve a numeric vector giving the dimensions of the image voxels in spatial units, typically mm.}
    \item{\code{getVoxelUnit()}:}{Retrieve the spatial unit used by \code{getVoxelDimensions()}. The most common value is \code{"mm"}. Can be the empty string if undefined.}
    \item{\code{getDataType()}:}{Retrieve a list describing the storage data type of the image. See \code{\link{getDataTypeByNiftiCode}} for details.}
    \item{\code{getOrigin()}:}{Retrieve the coordinate origin of the image.}
    \item{\code{getSource()}:}{Retrieve a character vector of length 1 giving the source file for the image. Returns \code{"internal"} if the image was not read from a file.}
    \item{\code{getStoredXformMatrix()}:}{Retrieve the ``xform'' matrix stored with the image. If the image was created internally, the result will be \code{NA}.}
    \item{\code{getTags()}:}{Retrieve any tags associated with the image, as a list of keys and values.}
    \item{\code{getTag(key)}:}{Retrieve the value associated with the specified key. If the key is not present, \code{NA} will be returned.}
    \item{\code{setSource(newSource)}:}{Set the source of the image.}
    \item{\code{isInternal()}:}{\code{TRUE} if the image was generated by a function, rather than read from a file.}
  }

The following methods are inherited (from the corresponding class):
serialise ("SerialisableObject"), methods ("SerialisableObject")
}
