% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.trafo_mod.R
\name{diagnostics.trafo_lm}
\alias{diagnostics.trafo_lm}
\title{Diagnostics for an untransformed and a transformed model}
\usage{
\method{diagnostics}{trafo_lm}(object, ...)
}
\arguments{
\item{object}{an object of type \code{trafo_lm}}

\item{...}{additional arguments that are not used in this method}
}
\value{
An object of class \code{diagnostics.trafo_lm}. The method 
\code{\link{print.diagnostics.trafo_lm}} can be used for this class.
}
\description{
Returns information about the applied transformation and selected diagnostics 
to check model assumptions. The return helps to compare the untransformed and 
the transformed model with regard to model assumptions.
}
\examples{
# Load data
data("cars", package = "datasets")

# Fit linear model
lm_cars <- lm(dist ~ speed, data = cars)

# Compare transformed models
BD_lm <- trafo_lm(object = lm_cars, trafo = "bickeldoksum", 
method = "skew", lambdarange = c(1e-11, 2))

# Get diagnostics
diagnostics(BD_lm)
}
