% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step1Measures.R
\name{Step1Measures}
\alias{Step1Measures}
\alias{print.trajMeasures}
\alias{summary.trajMeasures}
\title{Compute Measures for Identifying Patterns of Change in Longitudinal
Data}
\usage{
Step1Measures(
  Data,
  Time = NULL,
  ID = FALSE,
  measures = c(1:18),
  midpoint = NULL,
  cap.outliers = FALSE
)

\method{print}{trajMeasures}(x, ...)

\method{summary}{trajMeasures}(object, ...)
}
\arguments{
\item{Data}{a matrix or data frame in which each row contains the longitudinal
data (trajectories).}

\item{Time}{either \code{NULL}, a vector or a matrix/data frame of the same dimension
as \code{Data}. If a vector, matrix or data frame is supplied, its entries
are assumed to be measured at the times of the corresponding cells in
\code{Data}. When set to \code{NULL} (the default), the times are assumed
equidistant.}

\item{ID}{logical. Set to \code{TRUE} if the first columns of \code{Data} and
\code{Time} corresponds to an \code{ID} variable identifying the
trajectories. Defaults to \code{FALSE}.}

\item{measures}{a vector containing the numerical identifiers of the measures
to compute. The default, 1:18, corresponds to
measures 1-18 and thus excludes the measures which require specifying a
midpoint.}

\item{midpoint}{specifies which column of \code{Time} to use as the midpoint
in measure 19. Can be \code{NULL}, an integer or a vector of integers of length
the number of rows in \code{Time}. The default is \code{NULL}, in which case the
midpoint is the time closest to the median of the Time vector specific to
each trajectory.}

\item{cap.outliers}{logical. If \code{TRUE}, extreme values of the measures will be capped. If \code{FALSE}, only the infinite values will be capped. Defaults to \code{FALSE}.}

\item{x}{object of class \code{trajMeasures}.}

\item{...}{further arguments passed to or from other methods.}

\item{object}{object of class \code{trajMeasures}.}
}
\value{
An object of class \code{trajMeasures}; a list containing the values
of the measures, a table of the outliers which have been capped, as well as
a curated form of the function's arguments.
}
\description{
\code{Step1Measures} computes up to 19 measures for each
longitudinal trajectory. See Details for the list of measures.
}
\details{
Each trajectory must have a minimum of 3 observations otherwise it
will be omitted from the analysis.

The 19 measures and their numerical identifiers are listed below. Please
refer to the vignette for the specific formulas used to compute them.
\enumerate{
\item  Maximum\cr
\item  Range (max - min)\cr
\item  Mean value\cr
\item  Standard deviation\cr
\item  Intercept of linear model\cr
\item  Slope of the linear model\cr
\item  \eqn{R^2}: Proportion of variance explained by the linear model\cr
\item  Curve length (total variation)\cr
\item  Rate of intersection with the mean\cr
\item  Proportion of time spent above the mean\cr
\item  Minimum  of the first derivative\cr
\item  Maximum of the first derivative\cr
\item  Mean of the first derivative\cr
\item  Standard deviation of the first derivative\cr
\item  Minimum  of the second derivative\cr
\item  Maximum of the second derivative\cr
\item  Mean of the second derivative\cr
\item  Standard deviation of the second derivative\cr
\item  Later change/Early change\cr
}

If 'cap.outliers' is set to \code{TRUE}, or if some measures are infinite as a result of division by 0, Nishiyama's improved Chebychev bound for continuous distributions
is used to determine extreme values for each measure, corresponding to
a 0.3\% probability threshold. Extreme values beyond the threshold are then capped
to the 0.3\% probability threshold (see vignette for more details). If applicable, the values which
would be of the form 0/0 are set to 1.
}
\examples{
\dontrun{
data("trajdata")
trajdata.noGrp <- trajdata[, -which(colnames(trajdata) == "Group")] #remove the Group column

m1 = Step1Measures(trajdata.noGrp, ID = TRUE, measures = 19, midpoint = NULL)
m2 = Step1Measures(trajdata.noGrp, ID = TRUE, measures = 19, midpoint = 3)

identical(m1$measures, m2$measures)
}

}
\references{
Leffondre K, Abrahamowicz M, Regeasse A, Hawker GA, Badley EM,
McCusker J, Belzile E. Statistical measures were proposed for identifying
longitudinal patterns of change in quantitative health indicators. J Clin
Epidemiol. 2004 Oct;57(10):1049-62. doi: 10.1016/j.jclinepi.2004.02.012.
PMID: 15528056.

Nishiyama T, Improved Chebyshev inequality: new probability bounds with
known supremum of PDF, arXiv:1808.10770v2 stat.ME
https://doi.org/10.48550/arXiv.1808.10770
}
