% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\title{Normalize Text}
\usage{
normalize(..., concat = constant("concat"))
}
\arguments{
\item{...}{Any number of character vectors containing non-\link[base:NA]{NA}
elements. They can be empty.}

\item{concat}{A non-\link[base:NA]{NA} character string used to concatenate
values.}
}
\value{
A character string, possibly empty.
}
\description{
Ensure consistency of input text, allowing it to be written in a variety
of ways.
}
\details{
In what follows, a space character is defined as being an ASCII regular
space or an horizontal tab (\verb{\\t}). A new line is defined an ASCII line
feed (\verb{\\n}).

\code{\link[=normalize]{normalize()}} constructs a normalized string from all single-line and
multi-line strings passed to \code{...}. All underlying values are (implicitly)
coerced to character values in the process. It does so by going through
these 5 steps.
\enumerate{
\item It removes implicit new lines and spaces used for indentation from
multi-line strings. Empty lines are preserved.
\item It replaces empty values by a new line.
\item It concatenates values into a single character string using \code{concat}.
\item It removes leading and/or trailing new lines and/or spaces, including
those that could had been introduced temporarily at previous steps.
\item It replaces substrings of space characters by a single space.
}
}
\note{
The author is not satisfied with the current implementation. It is \emph{ugly},
and not fast enough. Calling \code{\link[=gsub]{gsub()}} five times yields a huge performance
penalty. Advices are welcome. \code{\link[=normalize]{normalize()}} will be revisited in a
near future.
}
\keyword{internal}
