% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqic_12.R
\name{seqic_indicator_12}
\alias{seqic_indicator_12}
\title{SEQIC Indicator 12 - Timeliness of Data Entry Post-Discharge}
\usage{
seqic_indicator_12(
  data,
  level,
  included_levels = c("I", "II", "III", "IV"),
  facility_id,
  exclude_facility_list = NULL,
  unique_incident_id,
  data_entry_time,
  data_entry_standard = 60,
  groups = NULL,
  calculate_ci = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame containing trauma incident records.}

\item{level}{Column indicating the trauma center designation level (e.g., I,
II, III, IV).}

\item{included_levels}{Character vector indicating what facility levels to
include in the analysis.  Defaults to \code{c("I", "II", "III", "IV")}.}

\item{facility_id}{Numeric, character, or factor. Column giving the unique
facility identifiers in the trauma dataset.}

\item{exclude_facility_list}{Optional. Numeric, character, or factor. List of
facilities to exclude from analysis due to known data quality issues or
other justifiable reasons. Defaults to \code{NULL}.}

\item{unique_incident_id}{Unique identifier for each record.}

\item{data_entry_time}{Numeric. Column representing the time in days between
patient discharge and trauma registry data entry.}

\item{data_entry_standard}{Numeric. The maximum allowable number of days
between discharge and data entry. Records entered within this threshold are
considered timely. Default is \code{60}.}

\item{groups}{Additional columns passed as a vector of strings to
\code{dplyr::summarize()} via the \code{.by} argument for grouped summaries. Defaults
to \code{NULL}.}

\item{calculate_ci}{If \code{NULL}, 95\% confidence intervals will not be
calculated for the performance estimates.  Otherwise, options of "wilson"
or "clopper-pearson" can be supplied to utilize the corresponding methods
to calculate the confidence intervals for the proportions. Defaults to
\code{NULL}.}

\item{...}{
  Arguments passed on to \code{\link[nemsqar:nemsqa_binomial_confint]{nemsqar::nemsqa_binomial_confint}}
  \describe{
    \item{\code{conf.level}}{Numeric value between 0 and 1 indicating the confidence
level. Defaults to 0.95 (95\% confidence interval).}
    \item{\code{correct}}{Logical, indicating whether to apply continuity correction for
Wilson intervals. Defaults to \code{TRUE}.}
  }}
}
\value{
A tibble summarizing SEQIC Indicator 12 results. Includes numerator,
denominator, and performance rate. 95\% confidence intervals are included if
requested.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Calculates the proportion of trauma cases where data were entered into the
trauma registry within a defined number of days post-discharge. This measure
supports trauma system quality improvement by identifying facilities meeting
timely documentation expectations.
}
\details{
This function:
\itemize{
\item Filters to include only patients treated at Level I–IV trauma
centers.
\item Excludes records from facilities specified by the user, if
applicable.
\item Deduplicates by \code{unique_incident_id} to ensure each incident is
counted once.
\item Flags records where data entry occurred within \code{data_entry_standard}
days of discharge.
\item Optionally calculates confidence intervals using methods from
\code{nemsqa_binomial_confint()}.
\item Returns a tibble with numerator,
denominator, and proportion of timely entries, with optional confidence
intervals and population/sample labels.
}

Users must ensure appropriate column names are passed and data is
pre-processed to include the necessary fields without missing critical
identifiers or timestamps.
}
\examples{
# Packages
library(dplyr)
library(traumar)

# Simulated data for SEQIC Indicator 12
test_data <- tibble::tibble(
  id = as.character(1:10),
  trauma_level = c("I", "II", "III", "IV", "II", "I", "IV", "III", "II",
  "I"),
  facility = c("A", "B", "C", "D", "A", "C", "B", "A", "C", "D"),
  data_entry_delay = c(30, 65, 10, 70, 45, 20, 80, 15, 55, 90)
)

# Run the function
traumar::seqic_indicator_12(
  data = test_data,
  level = trauma_level,
  included_levels = c("I", "II", "III", "IV"),
  facility_id = facility,
  unique_incident_id = id,
  exclude_facility_list = c("D"),
  data_entry_time = data_entry_delay,
  data_entry_standard = 60,
  calculate_ci = "wilson"
)

}
\author{
Nicolas Foss, Ed.D., MS
}
