% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_filter_fast.R
\name{time_filter_fast}
\alias{time_filter_fast}
\title{Time Filter (Fast)}
\usage{
time_filter_fast(
  locations,
  arrival_many_to_one = NULL,
  arrival_one_to_many = NULL
)
}
\arguments{
\item{locations}{One or more objects created by \code{\link{make_location}}}

\item{arrival_many_to_one}{One or more objects created by \code{\link{make_search}}}

\item{arrival_one_to_many}{One or more objects created by \code{\link{make_search}}}
}
\value{
API response parsed as a list and as a raw json
}
\description{
A very fast version of \code{\link{time_filter}}. However, the request parameters are much more limited.
Currently only supports UK and Ireland.
}
\details{
See \url{https://docs.traveltime.com/api/reference/time-filter-fast/} for details
}
\examples{
\dontrun{

locations <- c(
  make_location(
    id = 'London center',
    coords = list(lat = 51.508930, lng = -0.131387)),
  make_location(
    id = 'Hyde Park',
    coords = list(lat = 51.508824, lng = -0.167093)),
  make_location(
    id = 'ZSL London Zoo',
    coords = list(lat = 51.536067, lng = -0.153596))
  )
arrival_many_to_one <- make_search(id = "arrive-at many-to-one search example",
                                   arrival_location_id = "London center",
                                   departure_location_ids = list("Hyde Park", "ZSL London Zoo"),
                                   travel_time = 1900,
                                   transportation = list(type = "public_transport"),
                                   properties = list('travel_time', "fares"),
                                   arrival_time_period = "weekday_morning")

arrival_one_to_many <- make_search(id = "arrive-at one-to-many search example",
                                   departure_location_id = "London center",
                                   arrival_location_ids = list("Hyde Park", "ZSL London Zoo"),
                                   travel_time = 1900,
                                   transportation = list(type = "public_transport"),
                                   properties = list('travel_time', "fares"),
                                   arrival_time_period = "weekday_morning")

result <- time_filter_fast(locations, arrival_many_to_one, arrival_one_to_many)
}
}
