% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_treemap_subgroup_text.R
\name{geom_treemap_subgroup_text}
\alias{geom_treemap_subgroup_text}
\alias{geom_treemap_subgroup2_text}
\alias{geom_treemap_subgroup3_text}
\title{'ggplot2' geoms to add text labels to treemap subgroups.}
\usage{
geom_treemap_subgroup_text(mapping = NULL, data = NULL,
  stat = "identity", position = "identity", na.rm = FALSE,
  show.legend = FALSE, inherit.aes = TRUE, padding.x = grid::unit(1,
  "mm"), padding.y = grid::unit(1, "mm"), place = "bottom",
  min.size = 4, grow = FALSE, reflow = FALSE, fixed = NULL,
  layout = "squarified", start = "bottomleft", level = "subgroup",
  ...)

geom_treemap_subgroup2_text(...)

geom_treemap_subgroup3_text(...)
}
\arguments{
\item{mapping, data, stat, position, na.rm, show.legend, inherit.aes, ...}{Standard
geom arguments as for `ggplot2::geom_text`.}

\item{padding.x, padding.y}{`grid::unit` object, giving horizontal or vertical
padding between text and edge of tile. Defaults to 1 mm.}

\item{place}{Where inside the box to place the text. Default is `bottom`;
other options are `topleft`, `top`, `topright`, etc.}

\item{min.size}{Minimum font size, in points. If provided, text that would
need to be shrunk below this size to fit the box will not be drawn. Defaults
to 4 pt.}

\item{grow}{If `TRUE`, text will be grown as well as shrunk to fill the box.}

\item{reflow}{If `TRUE`, text will be reflowed (wrapped) to better fit the
box.}

\item{fixed}{Deprecated. Use `layout = "fixed"` instead. Will be removed in
later versions.}

\item{layout}{The layout algorithm, one of either "squarified" (the
default), "scol", "srow" or "fixed". See Details for full details on the
different layout algorithms.}

\item{start}{The corner in which to start placing the tiles. One of
'bottomleft' (the default), 'topleft', 'topright' or 'bottomright'.}

\item{level}{One of 'subgroup', 'subgroup2' or 'subgroup3', giving the
subgrouping level for which to draw text labels. It is recommended to use
the aliases `geom_treemap_subgroup2_text` and `geom_treemap_subgroup3_text`
instead of this argument.}
}
\description{
When `geom_treemap` is used with the `subgroup`, `subgroup2` or `subgroup3`
aesthetic to subgroup treemap tiles, `geom_treemap_subgroup_text`,
`geom_treemap_subgroup2_text` or `geom_treemap_subgroup3_text` can be used
to add a text label to each subgroup at the appropriate level.
}
\details{
`geom_treemap_subgroup_text` geoms require `area`, `label` and `subgroup`
(or `subgroup2`, `subgroup3`) aesthetics. Several other standard 'ggplot2'
aesthetics are supported (see Aesthetics).

`geom_treemap_subgroup_text` geoms use the 'ggfittext' package to fit text
to the subgroup. All text drawing options available in
`ggfittext::geom_fit_text` (growing, reflowing, etc.) are also available
here. For full details on how these options work, see the documentation for
`ggfittext::geom_fit_text`.

The `layout` argument is used to set the treemap layout algorithm. All
`treemapify` geoms added to a plot should have the same value for `layout`
and `start`, or they will not share a common layout (see `geom_treemap` for
details on the layout algorithms).
}
\section{Aesthetics}{


\itemize{
  \item area (required)
  \item subgroup, subgroup2 or subgroup3 (required; the value of this
  variable will be the text label)
  \item colour
  \item size
  \item alpha
  \item family
  \item fontface
  \item angle
}
}

\examples{

ggplot2::ggplot(G20, ggplot2::aes(area = gdp_mil_usd, fill = hdi,
                                  subgroup = hemisphere, subgroup2 = region)) +
  geom_treemap() +
  geom_treemap_subgroup_text(place = "centre", grow = TRUE, alpha = 0.5) +
  geom_treemap_subgroup2_text()

}
\seealso{
geom_treemap, geom_treemap_subgroup_border
}
