% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distFunctions.R
\name{polyDist}
\alias{polyDist}
\title{Calculates the distance between coefficient matrices}
\usage{
polyDist(x, Y, method = "logDiff", numThreads = -1)
}
\arguments{
\item{x}{single coefficient matrix to find distances to}

\item{Y}{a list of coefficient matrices}

\item{method}{method to use when calculating coefficient distances:
\describe{
  \item{\dQuote{logDiff}}{for two coefficient matrices A and B returns sum(log(1+abs(A-B))}
  \item{\dQuote{wLogDiff}}{performs the \dQuote{logDiff} method with weights on the rows}
  \item{\dQuote{pa}}{total pairs where the coefficient is present in one matrix and absent in the other (presence-absence)}
  \item{\dQuote{ap}}{opposite comparison of pa (absence-presence)}
}}

\item{numThreads}{number of threads to be used, the default (-1) will use the number of cores in the machine and numThreads = 0 will only use the main thread}
}
\value{
vector of distances
}
\description{
Calculates the distance between two coefficient matrices or a coefficient matrix and a list of coefficient matrices.
}
\note{
\itemize{
  \item the complex coefficient vector and the complex tip label coefficient matrix only support the \dQuote{logDiff} method
  \item \dQuote{pa} and \dQuote{ap} force symmetry in the output distance matrix
}
}
\examples{

library(treenomial)
library(ape)

# distance between coefficient matrices of one 10 tip tree
# and 100 trees with 30 tips using
# create the coefficient matrices
tenTipTree <- rtree(10)
tenTipTreeCoeff <- treeToPoly(tenTipTree, numThreads = 0)

thirtyTipList <- rmtree(100,30)
thirtyTipCoeffs <- treeToPoly(thirtyTipList, numThreads = 0)

# find the distance
polyDist(tenTipTreeCoeff,thirtyTipCoeffs, numThreads = 0)


}
