% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeplyr_functions.R
\name{filter_.treedata}
\alias{filter_.treedata}
\alias{filter.treedata}
\alias{filter_.grouped_treedata}
\alias{filter.grouped_treedata}
\title{Function for filtering rows from an object of class \code{treedata}}
\usage{
\method{filter_}{treedata}(.data, ..., .dots)

\method{filter_}{grouped_treedata}(.data, ..., .dots)
}
\arguments{
\item{.data}{An object of class \code{treedata}}

\item{...}{Additional arguments to filter by}

\item{.dots}{Used to work around non-standard evaluation. See \code{vignette}("nse") for details.}
}
\value{
An object of class \code{treedata} with the dataset filtered by the specified criteria.
}
\description{
This function can be used to select a subset of species (rows) from a treedata object; 
see \code{\link{filter}}.
}
\examples{
data(anolis)
td <- make.treedata(anolis$phy, anolis$dat, name_column=1)
tdfilter <- filter(td, island=="Cuba", SVL > 3.5)
}
\seealso{
\code{\link{filter}}
}
