% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{img_panel_local}
\alias{img_panel_local}
\title{Cast a vector of URLs pointing to local images as an image panel source}
\usage{
img_panel_local(x)
}
\arguments{
\item{x}{a vector of URLs pointing to images}
}
\description{
Cast a vector of URLs pointing to local images as an image panel source
}
\note{
\code{x} must be paths relative to the \code{path} argument passed to \code{\link{trelliscope}}.
}
\examples{
\dontrun{
# assuming images are available locally in relative path pokemon_local/images
pokemon$img <- img_panel_local(paste0("images/", basename(pokemon$url_image)))
trelliscope(pokemon, name = "pokemon", path = "pokemon_local")
}
}
